/***************************************************************************
 *   Calculation of Euler's Number to arbitrary decimal places		   *
 *   e.h - master header file                                              *
 *                                                                         *
 *   Copyright (C) 2005 by Musa A. Maharramov   			   *
 *                                                                         *
 *   Department of Applied Mathematics and Cybernetics			   * 
 *   Baku State University						   *
 *   musa@maharramov.com						   *
 *   www.maharramov.com							   *
 *						  			   *
 *   Permission is hereby granted, free of charge, to any person obtaining *
 *   a copy of this software and associated documentation files (the       *
 *   "Software"), to deal in the Software without restriction, including   *
 *   without limitation the rights to use, copy, modify, merge, publish,   *
 *   distribute, sublicense, and/or sell copies of the Software, and to    *
 *   permit persons to whom the Software is furnished to do so, subject to *
 *   the following conditions:                                             *
 *                                                                         *
 *   The above copyright notice and this permission notice shall be        *
 *   included in all copies or substantial portions of the Software.       *
 *                                                                         *
 *   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,       *
 *   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF    *
 *   MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.*
 *   IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR     *
 *   OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, *
 *   ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR *
 *   OTHER DEALINGS IN THE SOFTWARE.                                       *
 ***************************************************************************/

/*
	e.h - master header file
	
	Other project files include:

	e.cpp - the master file of the program calculting Euler's number
		or a specified part of the corresponding series
	strings.cpp - separately compiled string message file
		messagestrings.h - corresponding declaration file 
	longmath.h - high precision arithmetic header file
	longmath.cpp - separately compiled high precision arithmetic library
	longadd.cpp - a standalone program for adding two high-precision numbers
	calce.pl - a Perl script for automatically distributing the task across
		multiple systems
	ehosts.txt - a text file with a list of hosts to be used for performing 
		 the calculation (similar to e.g. LAM schema file)
	Makefile - make file for GNU make
 
*/


// include high-precision arithmetic - MM
#include "longmath.h"
#include <math.h>
// include separately compiled Project message strings - MM
#include "messagestrings.h"

