/***************************************************************************
 *   Calculation of Euler's Number and Pi to arbitrary decimal places	   *
 *   longadd.cpp - a standalone program for adding			   * 
 *	two high-precision numbers                                         *
 *                                                                         *
 *   Copyright (C) 2005 by Musa A. Maharramov   			   *
 *                                                                         *
 *   Department of Applied Mathematics and Cybernetics			   * 
 *   Baku State University						   *
 *   musa@maharramov.com						   *
 *   www.maharramov.com							   *
 *						  			   *
 *   Permission is hereby granted, free of charge, to any person obtaining *
 *   a copy of this software and associated documentation files (the       *
 *   "Software"), to deal in the Software without restriction, including   *
 *   without limitation the rights to use, copy, modify, merge, publish,   *
 *   distribute, sublicense, and/or sell copies of the Software, and to    *
 *   permit persons to whom the Software is furnished to do so, subject to *
 *   the following conditions:                                             *
 *                                                                         *
 *   The above copyright notice and this permission notice shall be        *
 *   included in all copies or substantial portions of the Software.       *
 *                                                                         *
 *   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,       *
 *   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF    *
 *   MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.*
 *   IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR     *
 *   OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, *
 *   ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR *
 *   OTHER DEALINGS IN THE SOFTWARE.                                       *
 ***************************************************************************/

/*
	longadd.cpp - a standalone program for adding two high-precision numbers
	
	Project files that depend on longadd:

	e.cpp - the master file of the program calculting Euler's number
		or a specified part of the corresponding series
	e.h - master header file
	pi.cpp - the master file of the program calculting Pi
		or a specified part of the corresponding series
	pi.h - master header file
	strings.cpp - separately compiled string message file
		messagestrings.h - corresponding declaration file 
	longmath.h - high precision arithmetic header file
	longmath.cpp - separately compiled high precision arithmetic library
	
	calce.pl - a Perl script for automatically distributing calculation
		of e across multiple systems
	calcpi.pl - a Perl script for automatically distributing calculation 
		of pi across multiple systems

	ehosts.txt - a text file with a list of hosts to be used for performing 
		 the calculation (similar to e.g. LAM schema file)
	Makefile - make file for GNU make
 
*/

// the following include file is ignored for UNIX-like systems
// and is required for the generation of Microsoft pre-compiled headers - MM

#ifdef _WIN32			
	#include "stdafx.h"
#endif

// include high-precision arithmetic - MM
#include "longmath.h"
// include separately compiled Project message strings - MM
#include "messagestrings.h"

#include <math.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>

// the following include file is ignored for UNIX-like systems
// and is specific to Microsoft Windows - MM
#ifdef _WIN32
	#include <io.h>
#else
// and this is its UNIX counterpart - MM
#include <unistd.h> 
#endif

// length of string variables/buffers - MM
#define MAXCHARS 512


unsigned int 
	uNoOfDigitsInLongNumber = 100; // default no of decimal places - MM

// command-line parameters - MM 
const char 
	// prefix for the required decimal places - MM 
	szcRequiredDecimaDigits[] = "-d\0",
	// prefix for names of files containing the numbers to be added - MM
	szcInputFilename[]="-f\0";

unsigned int
	// number of input files (i.e. numbers to be added) - MM
	uNoOfInputFiles = 0;	
char 
	// input filenames (max 128) - MM
	pszFileNames[128][MAXCHARS], 
	// pointers to text buffers containing the numbers to be added - MM
	* pszAddant[128];			 
	// .. and pointers to the corresponding high-precision numbers - MM
cLNUMBER * pNo[128];

bool bReadParams(int argc, char* argv[]) {
	int i = 1;
	while (i < argc) {
		if (strcmp(argv[i], szcRequiredDecimaDigits) == 0)  {
			i++; if (i==argc) return false;
			int digs = 0;
			sscanf(argv[i],"%d", &digs);
			// meaningful accuracy is from 4 to 100 million decimal places - MM 
			if  (digs < 4 || digs > 100000000) {
				printf(szcMessageDigitsRange);
				return false;
			}
			uNoOfDigitsInLongNumber = (unsigned int)digs;
			i++;
		}
		else if (strcmp(argv[i], szcInputFilename) == 0)  {
			i++; if (i==argc || uNoOfInputFiles == 128) return false;
			char szTempFilename[MAXCHARS+2];
			sscanf(argv[i],"%s", szTempFilename);
			if  (strlen(szTempFilename) >=MAXCHARS) {
				printf(szcMessageFileNameLength, MAXCHARS);
				return false;
			}
			strcpy(pszFileNames[uNoOfInputFiles], szTempFilename);
			pszAddant[uNoOfInputFiles] = NULL;
			uNoOfInputFiles++;
			i++;
		}
		else return false;
	}
	// read input files - MM
	for (unsigned i=0;i<uNoOfInputFiles;i++) {
		int FILE = open(pszFileNames[i], O_RDONLY);
		if (FILE == -1) {
			printf(szcMessageFailOpenFile, pszFileNames[i]);
			return false;
		}
		unsigned int uFileSize = lseek(FILE, 0, SEEK_END);
		pszAddant[i] = new char[uFileSize+2];
		if (!pszAddant[i]) {
			printf(szcMessageFailAllocMem);
			for (unsigned int j=0; j<i; j++) delete [] pszAddant[j];
			return false;
		}
		// initialise with 0s - MM
		memset(pszAddant[i],0,uFileSize+2);
		lseek(FILE, 0, SEEK_SET);
		read (FILE, pszAddant[i], uFileSize+2);
		close(FILE);
	}
	return true;
}


void printusage() {
	printf(szcMessageLongAddHelp);
}


int main(int argc, char* argv[])
{

	if (!bReadParams(argc, argv)) {
		printusage();
		return 1;
	}

	cLNUMBER * pA = new cLNUMBER(uNoOfDigitsInLongNumber);

	*pA = 0;
	for (unsigned int i=0; i<uNoOfInputFiles; i++) {
		pNo[i] = new cLNUMBER(uNoOfDigitsInLongNumber);
		pNo[i]->bFromString(pszAddant[i]);
		*pA = *pA+ *pNo[i];
	}

	pA->print();
	printf("\n");

	delete pA;
	for (unsigned int i=0; i<uNoOfInputFiles; i++) {
		delete pNo[i];
		delete [] pszAddant[i];
	}
	return 0;
}
