/***************************************************************************
 *   HIGH-PRECISION FIXED-POINT REAL ARITHMETIC CLASS LIBRARY		   *
 *   Version 0.5 Beta							   *
 *									   * 
 *   Copyright (C) 2005 by Musa A. Maharramov   			   *
 *                                                                         *
 *   Department of Applied Mathematics and Cybernetics			   * 
 *   Baku State University						   *
 *   musa@maharramov.com						   *
 *   www.maharramov.com							   *
 *                                                                         *
 *   This library has been specifically developed for high-precision 	   *
 *   calculation of PI and E.						   *
 * 									   *
 *   Implemented arithmetic operation include summation, subtraction 	   *
 *   and negation of high-precision fixed-point real numbers, and 	   *
 *   division by long signed integers.					   *
 *									   *
 *						  			   *
 *   Permission is hereby granted, free of charge, to any person obtaining *
 *   a copy of this software and associated documentation files (the       *
 *   "Software"), to deal in the Software without restriction, including   *
 *   without limitation the rights to use, copy, modify, merge, publish,   *
 *   distribute, sublicense, and/or sell copies of the Software, and to    *
 *   permit persons to whom the Software is furnished to do so, subject to *
 *   the following conditions:                                             *
 *                                                                         *
 *   The above copyright notice and this permission notice shall be        *
 *   included in all copies or substantial portions of the Software.       *
 *                                                                         *
 *   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,       *
 *   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF    *
 *   MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.*
 *   IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR     *
 *   OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, *
 *   ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR *
 *   OTHER DEALINGS IN THE SOFTWARE.                                       *
 ***************************************************************************/


// define this macro to ensure the file is included once - MM 
#ifndef LONGMATHINC 

#define LONGMATHINC

// define LONGBASE if the "unsigned long" supported by your C++ compiler can hold 1000000 - MM 
#define LONGBASE

#ifdef LONGBASE
#define BASE 1000000
#define NOOFDIGS 6
#else 
#define BASE 10000
#define NOOFDIGS 4
#endif

#include <stdio.h>
#include <string.h>
class cLNUMBER {
public:
	// sundry constructors - MM
	cLNUMBER (unsigned int uNoOfDigits) throw(char*);
	cLNUMBER (const cLNUMBER& Num) throw(char *);
	
	// summation and subtraction of long numbers - MM
	cLNUMBER& operator+(cLNUMBER& Num) throw(char*);
	cLNUMBER& operator-(cLNUMBER& Num) throw(char*);
	
	// for this algorithm of calculating Pi we only need devision by integer numbers - MM
	cLNUMBER& operator/(int Num) throw(char*);
	
	// assign another high-precision fixed-point or real number - MM
	cLNUMBER& operator=(cLNUMBER& Num) throw(char*);
	cLNUMBER& operator=(double Num) throw(char*);

	void Negate();

	// print out the long number - MM
	void print() const;

	// sign of the number - MM 
	// note that depending on no of digs in atom negatives are complements 
	// of +tives to 20000 (or 200000000) - MM
	int iSign() const {
		return (!uNoOfAtoms || !pData || (int((double)pData[0]/BASE) != 1) ? 
				1 : -1);
	};

	bool bFromString(char * pStr);

	virtual ~cLNUMBER();

private:
	unsigned int uNoOfAtoms;
	unsigned long * pData;
	
/*
Release() func and bGarbage variable are intended for garbage collection;
ReleaseMemory() is manually invoked for temporary objects not on stack - MM
*/
	void ReleaseMemory(); 
	bool bGarbage;
};


#endif // #ifdef LONGMATHINC
